-- new script file

function OnThink(self)
  if not self.initialized then
	  self.initialized = true
    self.looper = 4
	  self.p0 = Citadels.GetPlayer(0)
    
	  if not self.loaded then
      self.active = true
      self.timer = self.looper
    end
  end
  
  if self.active then
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
  
    if self.timer <= 0 then
	    CheckForPlayer(self)
      self.timer = self.looper
    end 
  end
end

function CheckForPlayer(self)
  p0units = self.p0:UnitsInRadiusNumber(self:GetPosition(), 2000, '*')
  
  if p0units > 1 then
    MarkQuest(self)
    self.active = false
  end
end

function MarkQuest(self)
  qPosX = Game:GetEntity("forwardBase"):GetPosition().x
  qPosY = Game:GetEntity("forwardBase"):GetPosition().y

  self.p0:AddQuest('D09_VALLEY', 'side')
  self.p0:SetQuestPosition('D09_VALLEY', qPosX, qPosY)
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    self.loaded = true
    self.active = ar:Read()
    self.timer = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.active)
    ar:Write(self.timer)
  end
end
